elexname		= CRegExpElex;
elexfilename	= ".\Elex\RegExpElex";

define = {*
int _getHex(char a)
{
	if (a >= '0' && a <= '9') return (int) (a - '0');
	if (a >= 'a' && a <= 'f') return (int) (a - 'a');
	if (a >= 'A' && a <= 'F') return (int) (a - 'A');
	return 0;
}

int _getOct(char a)
{
	return (int) (a - '0');
}

char _escape(const char* _str)
{
	switch (_str[1]) {
	case 'a': return '\a';
	case 'b': return '\b';
	case 'f': return '\f';
	case 'n': return '\n';
	case 'r': return '\r';
	case 't': return '\t';
	case 'v': return '\v';
	case '\\': return '\\';
	case 'x':
		{
			int a, b;
			a = _getHex(_str[2]);
			if (_str[3]) {
				b = _getHex(_str[3]);
				return a*16 + b;
			} else {
				return a;
			}
		}
	case '0':	case '1':	case '2':	case '3':	case '4':
	case '5':	case '6':	case '7':	case '8':	case '9':
		{
			int a = 0, b = 0, c = 0;
			if (_str[2]) {
				if (_str[3]) {
					// 3 digit octal
					a = _getOct(_str[1]);
					b = _getOct(_str[2]);
					c = _getOct(_str[3]);
				} else {
					// 2 digit octal
					b = _getOct(_str[1]);
					c = _getOct(_str[2]);
				}
			} else {
				// 1 digit octal
				c = _getOct(_str[1]);
			}

			return a * 8 * 8 + b * 8 + c;
		}
	}

	return _str[1];
}
*};

LPAREN					{:#(:};
RPAREN					{:#):};
LBRACK					{:#[:};
RBRACK					{:#]:};
LBRACE					{:#{:};
RBRACE					{:#}:};
RANGE					{:#-:};
ONE_OR_ZERO				{:#?:};
CLOSURE_ONE_OR_MORE		{:#+:};
CLOSURE_ZERO_OR_MORE	{:#*:};
NOT						{:#~:};
OR						{:#|:};
ANY						{:#_:};

NORCHR					{:(#(|#)|#[|#]|#?|#+|#*|#-|#~|#{|#}|#"|#||#\|##|#_)~:};

ESCCHR					{:#\((#\)|([#\0-9x]~)|([0-9][0-9]?[0-9]?)|(x[0-9a-fA-F][0-9a-fA-F]?)):}
{*
	char* pTemp = new char[2];
	pTemp[1] = 0;
	pTemp[0] = _escape(GetText());
	SetText(pTemp);
	delete[] pTemp;
*};

SHPCHR					{:##_:}
{*
	char* pTemp = new char[2];
	pTemp[1] = 0;
	pTemp[0] = GetText()[1];
	SetText(pTemp);
	delete[] pTemp;
*};

STRING					{:#"([#"#\]~|(#\#")|(#\#"~))*#":}
{*
	int i = 0, j = 0, k =0;
	char *pTemp = (char*) GetText();
	char *pStr;
	char pEscape[5];

	pEscape[4] = 0;

	if (strlen(pTemp) > 2) {
		pStr = new char[strlen(pTemp) - 1];

		for (i = 1; i < strlen(pTemp) - 1; i++) {
			if (pTemp[i] == '\\') {
				pEscape[0] = pTemp[i];

				if (pTemp[i+1] == 'x') {
					// hex
					pEscape[1] = pTemp[i + 1];

					if (   (pTemp[i+2] >= '0' && pTemp[i+2] <= '9')
						|| (pTemp[i+2] >= 'A' && pTemp[i+2] <= 'F')
						|| (pTemp[i+2] >= 'a' && pTemp[i+2] <= 'f')) {

						pEscape[2] = pTemp[i + 2];

						if (   (pTemp[i+3] >= '0' && pTemp[i+3] <= '9')
							|| (pTemp[i+3] >= 'A' && pTemp[i+3] <= 'F')
							|| (pTemp[i+3] >= 'a' && pTemp[i+3] <= 'f')) {

							pEscape[3] = pTemp[i + 3];
							pEscape[4] = 0;
							i += 3;

						} else {
							pEscape[3] = 0;
							i += 2;
						}

					} else {
						pEscape[2] = '0'; // error status
						pEscape[3] = 0;
						i += 1;
					}

				} else if (pTemp[i+1] >= '0' && pTemp[i+1] <= '9') {
					// octal
					pEscape[1] = pTemp[i + 1];

					if (pTemp[i + 2] >= '0' && pTemp[i + 2] <= '9') {
						pEscape[2] = pTemp[i + 2];

						if (pTemp[i + 3] >= '0' && pTemp[i + 3] <= '9') {
							pEscape[3] = pTemp[i + 3];
							i += 3;
							pEscape[4] = 0;

						} else {
							i += 2;
							pEscape[3] = 0;
						}

					} else {
						pEscape[2] = 0;
						i += 1;
					}
				} else {
					// just escape
					pEscape[1] = pTemp[i+1];
					pEscape[2] = 0;
					i += 1;
				}
				pStr[j++] = _escape(pEscape);
				pStr[j] = 0;
			} else {
				// normal character
				pStr[j++] = pTemp[i];
				pStr[j] = 0;
			}
		}
	} else {
		pStr = new char[1];
		pStr[1] = 0;
	}

	SetText(pStr);
	delete[] pStr;
*};

